<?php
$plugins->add_hook("parse_message", "ParseSpoiler");
$plugins->add_hook("parse_quoted_message", "ParseSpoilerQuote");

function advspoiler_info()
{
	return array(
		"name"		=> "Advanced Secure Spoiler",
		"description"	=> "Hides data in [spoiler] tag and also prevents specified user groups from seeing content of these tags .",
		"website"		=> "http://www.mybbiran.com",
		"author"		=> "Ahmad Badkoubehei",
		"authorsite"	=> "http://www.aucs.ir",
		"version"		=> "1.0",
		"guid"		=> "e3bd7719218609bab84f661893945051",
		"compatibility" => "16*"
	);
}
function advspoiler_activate()
{
	global $db, $mybb;

	$advspoiler = array(
		"gid"					=> "NULL",
		"name"				=> "advspoiler",
		"title"				=> "Advanced Secure Spoiler",
		"description"	=> "Make spoilers and hide theme from specific user groups",
		"disporder"		=> "4",
		"isdefault"			=> "no",
	);
	$db->insert_query("settinggroups", $advspoiler);
	$gid = $db->insert_id();
	
	$setting = array(
        "sid"					=> "NULL",
        "name"				=> "advspoiler_hide",
        "title"				=> "User groups which you want to prevent them from seeing spoiler contents",
        "description"	=> "Sperate groups with comma",
        "optionscode"	=> "text",
        "value"				=> "",
        "disporder"		=> "1",
        "gid"					=> intval($gid),
        );
    $db->insert_query("settings", $setting);
	
	rebuild_settings();
}
function advspoiler_deactivate()
{
	global $db, $mybb;
	
	$db->delete_query("settings","name IN('advspoiler_hide')");
	$db->delete_query("settinggroups", "name = 'advspoiler'");
	
	rebuild_settings();
}
function ParseSpoiler($message)
{
	global $lang,$mybb;
	
	if(file_exists($lang->path."/".$lang->language."/advspoiler.lang.php"))
	{
		$lang->load("advspoiler");
	}
	else
	{
		$l=$lang->language;
		$lang->set_language();
		$lang->load("advspoiler");
		$lang->set_language($l);
	}
	
	$pattern = "#\[spoiler\](.*?)\[/spoiler\]#si";

	if(in_array($mybb->user['usergroup'], explode(',', $mybb->settings['advspoiler_hide'])))
		$replace = $lang->advspoiler_notallow;
	else
		$replace = $lang->advspoiler_replace;

	$message = preg_replace($pattern, $replace, $message);

	return $message;
}

function ParseSpoilerQuote($page)
{
	global $lang,$mybb;
	
	if(file_exists($lang->path."/".$lang->language."/advspoiler.lang.php"))
	{
		$lang->load("advspoiler");
	}
	else
	{
		$l=$lang->language;
		$lang->set_language();
		$lang->load("advspoiler");
		$lang->set_language($l);
	}
	
	if(!in_array($mybb->user['usergroup'], explode(',', $mybb->settings['advspoiler_hide'])))
		return $page;
	$pattern = "#\[spoiler\](.*?)\[/spoiler\]#si";

	$replace = $lang->advspoiler_notallow_quote;
	
	foreach($page as $message){
		$page = preg_replace($pattern, $replace, $page);
	}

	return $page;
}
?>